 <?php
    session_start();
    include('./partials/config/config.php');
    include('./partials/config/checklogin.php');

    require_once('./partials/analytics.php');

    check_login();
    ?>

 <!DOCTYPE html>
 <html lang="en">

 <?php require_once './partials/_head.php' ?>

 <body>
     <div id="global-loader">
         <div class="whirly-loader"> </div>
     </div>

     <div class="main-wrapper">

         <?php require_once './partials/_header.php' ?>
         <?php require_once './partials/_sidebar.php' ?>

         <div class="page-wrapper">
             <div class="content">
                 <div class="page-header">
                     <div class="page-title">
                         <h4>EXPENSES</h4>
                         <h6>Manage your expenses</h6>
                     </div>
                     <div class="page-btn">
                         <a href="addexpense.php" class="btn btn-added">
                             <img src="assets/img/icons/plus.svg" alt="img">Add Expense
                         </a>
                     </div>
                 </div>

                 <div class="card">
                     <div class="card-body">
                         <div class="table-top">
                             <div class="search-set">
                                 <div class="search-path">
                                     <a class="btn btn-filter" id="filter_search">
                                         <img src="assets/img/icons/filter.svg" alt="img">
                                         <span><img src="assets/img/icons/closes.svg" alt="img"></span>
                                     </a>
                                 </div>
                                 <div class="search-input">
                                     <a class="btn btn-searchset"><img src="assets/img/icons/search-white.svg" alt="img"></a>
                                 </div>
                             </div>
                             <div class="wordset">
                                 <ul>
                                     <li>
                                         <a data-bs-toggle="tooltip" data-bs-placement="top" title="pdf"><img src="assets/img/icons/pdf.svg" alt="img"></a>
                                     </li>
                                     <li>
                                         <a data-bs-toggle="tooltip" data-bs-placement="top" title="excel"><img src="assets/img/icons/excel.svg" alt="img"></a>
                                     </li>
                                     <li>
                                         <a data-bs-toggle="tooltip" data-bs-placement="top" title="print"><img src="assets/img/icons/printer.svg" alt="img"></a>
                                     </li>
                                 </ul>
                             </div>
                         </div>

                         <div class="table-responsive">
                             <table class="table datanew">
                                 <thead>
                                     <tr>
                                         <th>
                                             <label class="checkboxs">
                                                 <input type="checkbox" id="select-all">
                                                 <span class="checkmarks"></span>
                                             </label>
                                         </th>
                                         <th>Reference</th>
                                         <th>Expense Name</th>
                                         <th>Category</th>
                                         <th>Description</th>
                                         <th>Date</th>
                                         <th>Amount</th>
                                         <th>Status</th>
                                         <th>Action</th>
                                     </tr>
                                 </thead>
                                 <tbody>


                                     <tr>
                                         <td>
                                             <label class="checkboxs">
                                                 <input type="checkbox">
                                                 <span class="checkmarks"></span>
                                             </label>
                                         </td>
                                         <td class="text-bolds">Best Power Tools</td>
                                         <td>PT005</td>
                                         <td>19 Nov 2022</td>
                                         <td><span class="badges bg-lightred">Pending</span></td>
                                         <td>210</td>
                                         <td>210</td>
                                         <td><span class="badges bg-lightred">UnPaid</span></td>
                                         <td>
                                             <a class="me-3" href="editpurchase.php">
                                                 <img src="assets/img/icons/edit.svg" alt="img">
                                             </a>
                                             <a class="me-3 confirm-text" href="javascript:void(0);">
                                                 <img src="assets/img/icons/delete.svg" alt="img">
                                             </a>
                                         </td>
                                     </tr>

                                 </tbody>
                             </table>
                         </div>
                     </div>
                 </div>

             </div>
         </div>
     </div>


     <?php require_once './partials/_scripts.php' ?>

 </body>

 </html>