<?php
session_start();
include('./partials/config/config.php');
include('./partials/config/checklogin.php');
include('./partials/config/code-generator.php');

require_once('./partials/analytics.php');

check_login();

if (isset($_POST['banip'])) {
    //Prevent Posting Blank Values
    if (empty($_POST["ip"]) || empty($_POST["reason"])) {
        $err = "Blank Values Not Accepted";
    } else {
        $id = $mpesaCode;
        $ip = $_POST['ip'];
        $reason = $_POST['reason'];

        $staff_id = $_SESSION['user_id'];

        $created_at = date("Y-m-d H:i:s");

        //Insert Captured information to a database table
        $postQuery = "INSERT INTO tbl_bannedip (id, ip, reason, created_at, staff_id) VALUES(?,?,?,?,?)";
        $postStmt = $mysqli->prepare($postQuery);
        //bind paramaters
        $rc = $postStmt->bind_param('sssss', $id, $ip, $reason, $created_at, $staff_id);
        $postStmt->execute();
        //declare a varible which will be passed to alert function
        if ($postStmt) {

            $success = "IP Address Bannned" && header("refresh:1; url=systemsettings.php");
        } else {
            $err = "Please Try Again Or Try Later";
        }
    }
}


?>

<!DOCTYPE html>
<html lang="en">

<?php require_once './partials/_head.php' ?>

<body>

    <div class="main-wrapper">

        <?php require_once './partials/_header.php' ?>
        <?php require_once './partials/_sidebar.php' ?>

        <div class="page-wrapper">
            <div class="content">
                <div class="page-header">
                    <div class="page-title">
                        <h4>System Settings</h4>
                    </div>
                </div>

                <div class="card">
                    <div class="card-body">
                        <div class="row">
                            <h5 style="font-weight: bold;">Emailing Systems Integration</h5>

                            <div class="col-lg-6 col-sm-6 col-12">
                                <div class="card">
                                    <div class="card-body">
                                        <button type="button" class="btn btn-outline-dark">Not Connected</button>
                                        <h5 class="card-title">PHP Mailer</h5>
                                        <p class="card-text">Used to send emails easily via PHP code from a web server.</p>
                                        <a href="#" class="btn btn-primary">View Integration</a>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-6 col-sm-6 col-12">
                                <div class="card">
                                    <div class="card-body">
                                        <button type="button" class="btn btn-outline-dark">Not Connected</button>
                                        <h5 class="card-title">SMTP</h5>
                                        <p class="card-text">SMTP is used to send, relay or forward messages from a mail client.</p>
                                        <a href="#" class="btn btn-primary">View Integration</a>
                                    </div>
                                </div>
                            </div>

                        </div>
                    </div>
                </div>

                <div class="card">
                    <div class="page-header m-2 p-2">
                        <div class="page-title">
                            <h4>Email Templates</h4>
                        </div>
                        <div class="page-btn">
                            <a href="addemailtemplate.php" class="btn btn-added"><img src="assets/img/icons/plus.svg" alt="img">Add Email Template</a>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="table-top">
                            <div class="search-set">
                                <div class="search-path">
                                    <a class="btn btn-filter" id="filter_search">
                                        <img src="assets/img/icons/filter.svg" alt="img">
                                        <span><img src="assets/img/icons/closes.svg" alt="img"></span>
                                    </a>
                                </div>
                                <div class="search-input">
                                    <a class="btn btn-searchset"><img src="assets/img/icons/search-white.svg" alt="img"></a>
                                </div>
                            </div>
                            <div class="wordset">
                                <ul>
                                    <li>
                                        <a data-bs-toggle="tooltip" data-bs-placement="top" title="pdf"><img src="assets/img/icons/pdf.svg" alt="img"></a>
                                    </li>
                                    <li>
                                        <a data-bs-toggle="tooltip" data-bs-placement="top" title="excel"><img src="assets/img/icons/excel.svg" alt="img"></a>
                                    </li>
                                    <li>
                                        <a data-bs-toggle="tooltip" data-bs-placement="top" title="print"><img src="assets/img/icons/printer.svg" alt="img"></a>
                                    </li>
                                </ul>
                            </div>
                        </div>

                        <div class="table-responsive">
                            <table class="table datanew">
                                <thead>
                                    <tr>
                                        <th>
                                            <label class="checkboxs">
                                                <input type="checkbox" id="select-all">
                                                <span class="checkmarks"></span>
                                            </label>
                                        </th>
                                        <th>sn</th>
                                        <th>Title</th>
                                        <th>Created On</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td>
                                            <label class="checkboxs">
                                                <input type="checkbox">
                                                <span class="checkmarks"></span>
                                            </label>
                                        </td>
                                        <td class="productimgname">
                                            <a href="javascript:void(0);">SDSD</a>
                                        </td>
                                        <td>Sprays</td>
                                        <td>Sprays</td>
                                        <td>
                                            <a class="me-3" href="editsupplier.php">
                                                <img src="assets/img/icons/edit.svg" alt="img">
                                            </a>
                                            <a class="me-3 confirm-text" href="javascript:void(0);">
                                                <img src="assets/img/icons/delete.svg" alt="img">
                                            </a>
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>


                <div class="card">
                    <div class="page-header m-2 p-2">
                        <div class="page-title">
                            <h4>Banned Ip Addresses</h4>
                        </div>
                        <div class="input-groupicon">
                            <button class="btn btn-success" data-bs-toggle="modal" data-bs-target="#banip">Ban an IP Address</button>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="table-top">
                            <div class="search-set">
                                <div class="search-path">
                                    <a class="btn btn-filter" id="filter_search">
                                        <img src="assets/img/icons/filter.svg" alt="img">
                                        <span><img src="assets/img/icons/closes.svg" alt="img"></span>
                                    </a>
                                </div>
                                <div class="search-input">
                                    <a class="btn btn-searchset"><img src="assets/img/icons/search-white.svg" alt="img"></a>
                                </div>
                            </div>
                            <div class="wordset">
                                <ul>
                                    <li>
                                        <a data-bs-toggle="tooltip" data-bs-placement="top" title="pdf"><img src="assets/img/icons/pdf.svg" alt="img"></a>
                                    </li>
                                    <li>
                                        <a data-bs-toggle="tooltip" data-bs-placement="top" title="excel"><img src="assets/img/icons/excel.svg" alt="img"></a>
                                    </li>
                                    <li>
                                        <a data-bs-toggle="tooltip" data-bs-placement="top" title="print"><img src="assets/img/icons/printer.svg" alt="img"></a>
                                    </li>
                                </ul>
                            </div>
                        </div>

                        <div class="table-responsive">
                            <table class="table datanew">
                                <thead>
                                    <tr>
                                        <th>
                                            <label class="checkboxs">
                                                <input type="checkbox" id="select-all">
                                                <span class="checkmarks"></span>
                                            </label>
                                        </th>
                                        <th>sn</th>
                                        <th>IP Address</th>
                                        <th>Reason</th>
                                        <th>Created On</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td>
                                            <label class="checkboxs">
                                                <input type="checkbox">
                                                <span class="checkmarks"></span>
                                            </label>
                                        </td>
                                        <td class="productimgname">
                                            <a href="javascript:void(0);">SDSD</a>
                                        </td>
                                        <td>Sprays</td>
                                        <td>Sprays</td>
                                        <td>Sprays</td>
                                        <td>
                                            <a class="me-3" href="editsupplier.php">
                                                <img src="assets/img/icons/edit.svg" alt="img">
                                            </a>
                                            <a class="me-3 confirm-text" href="javascript:void(0);">
                                                <img src="assets/img/icons/delete.svg" alt="img">
                                            </a>
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>


    <?php require_once './partials/_scripts.php' ?>


    <!-- modal section -->

    <div class="modal fade" id="banip" tabindex="-1" aria-labelledby="addproduct" aria-hidden="true">
        <div class="modal-dialog modal-lg modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Ban Ip Address</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"><span aria-hidden="true">×</span></button>
                </div>
                <div class="modal-body">
                    <form action="" role="form" method="post">
                        <div class="row">

                            <div class="col-lg-12 col-sm-12 col-12">
                                <div class="form-group">
                                    <label>IP Address</label>
                                    <input type="text" name="ip" class="form-control" required>
                                </div>
                            </div>

                            <div class="col-lg-12 col-sm-12 col-12">
                                <div class="form-group">
                                    <label>Reason</label>
                                    <textarea name="reason" required id=""></textarea>
                                </div>
                            </div>

                            <div class="col-lg-3 col-sm-6 col-12">
                                <div class="form-group">
                                    <button type="submit" name="banip" class="btn btn-submit">ADD</button>
                                </div>
                            </div>

                        </div>
                    </form>
                </div>

            </div>
        </div>
    </div>

</body>

</html>